#!/bin/sh
# ISPsystem install v.4

Usage()
{
	cat << EOU >&2

Usage:
	$0 --help 	Print this help

	$0 [options] [mgrname]
	--os OS		Force use OS distribution
	--arch ARCH	Force use ARCH architecture
	--ip IP		Use IP for licence check
	--type		License type
	
EOU
}

DetectFetch()
{
	if test -x /usr/bin/fetch; then
		fetch="/usr/bin/fetch -o "
	elif test -x /usr/bin/wget; then
		fetch="/usr/bin/wget -O "
	elif test -x /usr/bin/curl; then
		fetch="/usr/bin/curl -o "
	else
		echo "ERROR: no fetch program found."
		exit 1
	fi
}

DetectMd5()
{
	if test -x /sbin/md5; then
		md5="/sbin/md5 "
		isit=true
	elif test -x /usr/bin/md5sum; then
		md5="/usr/bin/md5sum "
		isit=false
	else
		echo "ERROR: no programm for checksum found."
		exit 1
	fi
}

DetectOS()
{
	kern=`uname -s`
	case "$kern" in
		FreeBSD)
			ver=`uname -r|sed -E 's/^([0-9]+\.[0-9]+).*$/\1/'`
			os="$kern-$ver"
			;;
		Darwin)
			os="Darwin"
			;;
		Linux)
			os="Linux-cc6"
#			if test -e "/usr/lib/libstdc++.so.7" -o -e "/usr/lib/libstdc++-v3/libstdc++.so.7"; then
#				os="Linux-cc7"
#			elif test -e "/usr/lib/libstdc++.so.6" -o -e "/usr/lib/libstdc++-v3/libstdc++.so.6"; then
#				os="Linux-cc6"
#			else
#				os="Linux-cc5"
#			fi	
			;;
		*)
			echo "Unknown OS type"
			exit 1
			;;
	esac
}

DetectArch()
{
	arch=`uname -m`
}

PingTest() {
    ITER=5
    ping -q -c ${ITER} -n ${1} 2>&1 | tail -1 | awk -F '/' '{print $5}' | awk -F. '{print $1}'
}

Errorv4() {
	echo "Software products of the 4th generation cannot be installed. We no longer support ISPsystem's software v4 and and recommend that you install products of the 5th version"
	echo "You can use http://download.ispsystem.com/install.sh for this"
	echo
	exit
}


GetFastestMirror() {
    PRU=$(PingTest download.ispsystem.com)
    if [ ${PRU} -lt 10 ]; then
        echo download.ispsystem.com
        return 0
    fi
    PCDN=$(PingTest cdn.ispsystem.com)
    if [ ${PRU} -lt ${PCDN} ]; then
        echo download.ispsystem.com
    else
        echo cdn.ispsystem.com
    fi
}

echo
echo "ISPsystem install v.4.4"
echo

while true
do
	case "$1" in 
		-h | --help)
			Usage
			exit 0
			;;
		--os)
			os=${2:-.}
			shift 2
			;;
		--arch)
			arch=${2:-.}
			shift 2
			;;
		--force)
			force="true"
			shift 1
			;;
		--ip)
			ip=${2:-.}
			ipparam="ip=$ip"
			shift 2
			;;
		-t | --type)
			license_type=${2}
			shift 2
			;;
		-*)
			echo Unrecognized flag : "$1" >&2
			Usage
			exit 1
			;;
		*)
			break ;;
	esac
done

DetectFetch
DetectMd5



if test "$os" = ""; then
	DetectOS
fi

if test "$arch" = ""; then
	DetectArch
fi

if test $# -eq 0 ; then
	
#	if test "$list" = "no_license_found"; then
#		echo "You have no active licenses"
#		exit 1
#	fi


	mgrlist="ISPmanager BILLmanager VDSmanager DCImanager DNSmanager IPmanager VMmanager VEmanager"
	while true 
	do
		echo
		echo
		j="1"
		for i in $mgrlist; do
			echo "$j) $i"
			eval "mgrval$j=$i"
			j=$(($j+1))
		done

		echo "0) Exit"
		echo
		read -p "Please choose software to install: " n
		echo
		
		if test "$n" = "1"; then
#			mgrname=ISPmanager-Lite
#			isplist="ISPmanager-Lite ISPmanager-Pro ISPmanager-Cluster";
			isplist="ISPmanager-Lite ISPmanager-Pro";
			j="1"
			for i in $isplist; do
				echo "$j) $i"
				eval "ispval$j=$i"
				j=$(($j+1))
			done

			echo "0) Back"
			echo
			read -p "Please choose ISPmanager version: " v
			echo

			if test "$v" != "0"; then
				eval mgrname=\$ispval$v
			fi

		elif test "$n" = "2"; then
			Errorv4
			billlist="BILLmanager-Standart BILLmanager-Advanced BILLmanager-Corporate BILLmanager-RUCENTER";
			j="1"
			for i in $billlist; do
				echo "$j) $i"
				eval "ispval$j=$i"
				j=$(($j+1))
			done

			echo "0) Back"
			echo
			read -p "Please choose BILLmanager version: " v
			echo

			if test "$v" != "0"; then
				eval mgrname=\$ispval$v
			fi
		elif test "$n" = "3"; then
			Errorv4
			kern=`uname -s`
			case "$kern" in
				FreeBSD)
					mgrname="VDSmanager-FreeBSD"
					;;
				Linux)
					mgrname="VDSmanager-Linux"
					;;
				*)
					echo "VDSmanager not available for this OS"
					exit 1
					;;
			esac

		elif test "$n" = "0"; then
			exit 0
		else
			Errorv4
			eval mgrname=\$mgrval$n
			echo $mgrname
		fi
	
		if test "$mgrname" != ""; then
			break;
		fi
	done
else
	mgrname=$1
fi

# check licence 
while true
do
	echo "Checking license ..."
	#$fetch /tmp/1.$$.tmp -q "http://lic.ispsystem.com/liclist.cgi?$ipparam" && mv /tmp/1.$$.tmp /tmp/$$.tmp &
	#$fetch /tmp/2.$$.tmp -q "http://lic2.ispsystem.com/liclist.cgi?$ipparam" && mv /tmp/2.$$.tmp /tmp/$$.tmp &
	echo "${license_type}" > /tmp/$$.tmp

	i=0
	while [ ! -f /tmp/$$.tmp ]; do
		if [ $i -gt 60 ]; then
			echo "Unable to load license"
			exit
		fi

		sleep 1
		i=$(($i + 1))
	done

	activelist=$(cat /tmp/$$.tmp)
	for i in $activelist; do
		if test "$mgrname" = "$i"; then
			ok="1"
		fi
	done

	if test "$ok" = "1"; then
		break
	fi

	if test "$mgrname" = "ISPmanager-Lite"; then
		url="https://my.ispsystem.com/manager/billmgr?func=register&project=1&welcomfunc=software.order&welcomparam=price=5%20period=2"
	elif test "$mgrname" = "ISPmanager-Pro"; then
		url="https://my.ispsystem.com/manager/billmgr?func=register&project=1&welcomfunc=software.order&welcomparam=price=9%20period=10"
	elif test "$mgrname" = "ISPmanager-Cluster"; then
		url="https://my.ispsystem.com/manager/billmgr?func=register&project=1&welcomfunc=software.order&welcomparam=price=112%20period=68"
	elif test "$mgrname" = "BILLmanager-Standart"; then
		url="https://my.ispsystem.com/manager/billmgr?func=register&project=1&welcomfunc=software.order&welcomparam=price=432%20period=246"
	elif test "$mgrname" = "BILLmanager-Advanced"; then
		url="https://my.ispsystem.com/manager/billmgr?func=register&project=1&welcomfunc=software.order&welcomparam=price=434%20period=247"
	elif test "$mgrname" = "BILLmanager-Corporate"; then
		url="https://my.ispsystem.com/manager/billmgr?func=register&project=1&welcomfunc=software.order&welcomparam=price=435%20period=248"
	elif test "$mgrname" = "VDSmanager-FreeBSD"; then
		url="https://my.ispsystem.com/manager/billmgr?func=register&project=1&welcomfunc=software.order&welcomparam=price=884%20period=534"
	elif test "$mgrname" = "VDSmanager-Linux"; then
		url="https://my.ispsystem.com/manager/billmgr?func=register&project=1&welcomfunc=software.order&welcomparam=price=15%20period=24"
	elif test "$mgrname" = "DNSmanager"; then
		url="https://my.ispsystem.com/manager/billmgr?func=register&project=1&welcomfunc=software.order&welcomparam=price=3136%20period=1926"
	elif test "$mgrname" = "IPmanager"; then
		url="https://my.ispsystem.com/manager/billmgr?func=register&project=1&welcomfunc=software.order&welcomparam=price=2891%20period=1814"
	elif test "$mgrname" = "DCImanager"; then
		url="https://my.ispsystem.com/manager/billmgr?func=register&project=1&welcomfunc=software.order&welcomparam=price=3932%20period=2543"
	elif test "$mgrname" = "VMmanager"; then
		url="https://my.ispsystem.com/manager/billmgr?func=register&project=1&welcomfunc=software.order&welcomparam=price=3045%20period=1898"
	elif test "$mgrname" = "VMmanager"; then
		url="https://my.ispsystem.com/manager/billmgr?func=register&project=1&welcomfunc=software.order&welcomparam=price=3651%20period=2363"
	fi

	echo
	echo "You don't have the active license for this server."
        echo "Please, use the following URL to order a trial $mgrname license"
	echo "$url"
	echo "Moreover, you may specify another ip using the  --ip option."
	echo "When you order the license, press the Enter button to continue or Ctrl+C to abort installation."
	read t
done

if test -x /usr/bin/ntpdate; then
	/usr/bin/ntpdate -b pool.ntp.org
fi

tmpdir="/tmp/$mgrname"
mkdir -p $tmpdir
cd $tmpdir

if test "$n" = "1" || test "$n" = "5" || test "$n" = "6"; then
	read -p "What version of product do You want install: 4 or 5 ?" cv
	if test "$cv" = "5"; then
		shfile=$tmpdir/install.5.sh
		shurl="http://download.ispsystem.com/install.5.sh"
		$fetch $shfile "$shurl"
		clear
		sh $shfile
		exit 0
	elif [ -z "$force" ]; then
		kern=`uname -s`
		if [ $kern = "FreeBSD" ]; then
			echo "================================"
			echo "Automatic installation ISPmanager-4 on FreeBSD is not supported."
			echo "Use ISPmanager-5 or Linux system instead"
			echo ""
			echo "If You really want to install ISPmanager-4 You should run script with \"--force\" flag"
			echo "================================"
			exit 0
		fi
	fi
elif test "$n" = "4" || test "$n" = "7" || test "$n" = "8"; then
	shfile=$tmpdir/install.5.sh
	shurl="http://download.ispsystem.com/install.5.sh"
	$fetch $shfile "$shurl"
	clear
	sh $shfile
	exit 0
fi


echo "Detecting fastest mirror..."
mirror=$(GetFastestMirror)

stable="false"
goon="true"
while [ $goon = "true" ]
do
    goon="false"
    echo "1) beta version - has the latest functionality"
    echo "2) stable version - time-proved version"
    echo
    read -p "Please choose version to install: " n
    echo

    if [ "$n" = "1" ]; then 
		url="http://$mirror/$os/$arch/$mgrname/install.tgz"
    elif [ "$n" = "2" ]; then
		url="http://$mirror/$os/$arch/$mgrname/install.stable.tgz"
		stable="true";
    else goon="true"; fi
done

archive="$tmpdir/install.tgz"

test -f $archive && rm -f $archive
$fetch $archive "$url"

if ! test -s $archive; then
	echo "Can't download $mgrname distribution"
	echo "Make sure it is available for your platform ($os $arch)"
	echo "List of supported distribution you can see at"
	echo "http://download.ispsystem.com/"
	echo "see $0 --help for more information"
	rm -rf $tmpdir
	exit 1
fi

# check md5
$fetch $archive.md5 "$url.md5"

if test "$isit" = "true"; then
	remotesum=`cat $archive.md5 | awk '{print $4}'`
	localsum=`$md5 install.tgz | awk '{print $4}'`
else
	remotesum=`cat $archive.md5 | awk '{print $1}'`
	localsum=`$md5 install.tgz | awk '{print $1}'`
fi

if test "$localsum" != "$remotesum"; then
	echo "Invalid MD5 signature"
	echo "Please try again."
	rm -rf $tmpdir
	exit 1
fi

mgrdir="/usr/local/ispmgr/"
mkdir -p $mgrdir
cd $mgrdir
bin=`tar xvzpf $archive 2>&1 | grep -v 'sbin' | grep 'bin/.' | sed -e 's/^.*\///'`
rm -rf $tmpdir

echo "Mirror http://$mirror/" >> $mgrdir/etc/dist/$bin.conf
if test "$stable" = "true"; then
	echo "Release stable" >> $mgrdir/etc/dist/$bin.conf
fi

installname=`echo ${mgrname} | sed -e 's/-.*$//'`

if test "$installname" = "ISPmanager"; then
        $fetch etc/ispmgr.lic -q "http://lic.ispsystem.com/ispmgr.lic?$ipparam" &
        $fetch etc/ispmgr.lic -q "http://lic2.ispsystem.com/ispmgr.lic?$ipparam" &

        i=0
        while [ ! -f etc/ispmgr.lic ]; do
                if [ $i -gt 60 ]; then
                        echo "Unable to load license"
                        exit
                fi

                sleep 1
                i=$(($i + 1))
        done
fi

sh sbin/${installname}-install.sh $mirror $ip


